/*
 * Decompiled with CFR 0.152.
 */
package com.alc.moreminecarts.blocks.powered_rails;

import com.alc.moreminecarts.MMConstants;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.vehicle.AbstractMinecart;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.PoweredRailBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.RailShape;
import net.minecraft.world.phys.Vec3;

public class PoweredLightspeedRail
extends PoweredRailBlock {
    public PoweredLightspeedRail(BlockBehaviour.Properties builder) {
        super(builder, true);
    }

    public float getRailMaxSpeed(BlockState state, Level world, BlockPos pos, AbstractMinecart cart) {
        return MMConstants.LIGHTSPEED_MAX_SPEED;
    }

    public boolean canMakeSlopes(BlockState state, BlockGetter world, BlockPos pos) {
        return false;
    }

    public void m_7892_(BlockState state, Level worldIn, BlockPos pos, Entity entityIn) {
        if (worldIn.m_5776_()) {
            return;
        }
        if (((Boolean)state.m_61143_((Property)f_55215_)).booleanValue() && entityIn instanceof AbstractMinecart) {
            AbstractMinecart minecart = (AbstractMinecart)entityIn;
            if (!minecart.shouldDoRailFunctions()) {
                return;
            }
            RailShape railshape = this.getRailDirection(state, (BlockGetter)worldIn, pos, minecart);
            Vec3 minecartVelocity = minecart.m_20184_();
            double minecartSpeedMagnitude = minecartVelocity.m_165924_();
            if (minecartSpeedMagnitude > 0.01) {
                double d19 = MMConstants.POWERED_LIGHTSPEED_BOOST;
                minecart.m_20256_(minecartVelocity.m_82520_(minecartVelocity.f_82479_ / minecartSpeedMagnitude * d19, 0.0, minecartVelocity.f_82481_ / minecartSpeedMagnitude * d19));
            } else {
                Vec3 vector3d7 = minecart.m_20184_();
                double d20 = vector3d7.f_82479_;
                double d21 = vector3d7.f_82481_;
                if (railshape == RailShape.EAST_WEST) {
                    if (this.isRedstoneConductor(worldIn, pos.m_142125_())) {
                        d20 = 0.02;
                    } else if (this.isRedstoneConductor(worldIn, pos.m_142126_())) {
                        d20 = -0.02;
                    }
                } else {
                    if (railshape != RailShape.NORTH_SOUTH) {
                        return;
                    }
                    if (this.isRedstoneConductor(worldIn, pos.m_142127_())) {
                        d21 = 0.02;
                    } else if (this.isRedstoneConductor(worldIn, pos.m_142128_())) {
                        d21 = -0.02;
                    }
                }
                minecart.m_20334_(d20, vector3d7.f_82480_, d21);
            }
        }
    }

    private boolean isRedstoneConductor(Level world, BlockPos p_213900_1_) {
        return world.m_8055_(p_213900_1_).m_60796_((BlockGetter)world, p_213900_1_);
    }
}

